@echo off
REM ---------------------------------------------------------------------------
REM
REM  Copyright (C) Intel Corporation, 2003 - 2006.
REM
REM  File:      gencertchain.bat
REM
REM  Contents:  batch file which creates a certificate chain file in the format
REM				required by the Intel(R) Active Management Technology device. 
REM
REM ----------------------------------------------------------------------------


REM ######################################################################
REM ###                                                                ###
REM ### This file is called by the Configuration Server program         ###
REM ### in order to make a certificate for an Intel(R) Active	       ###
REM ### Management Technology device.								   ###
REM ###																   ###
REM ### This script calls certgen.bat to generate a certificate for    ###
REM ### the device being provisioned, and then uses CertChainBuilder   ###
REM ### executable to create a trust chain starting at the root CA.    ###
REM ### you may customize this script and modify the defaults          ###
REM ### at your own risk.                                              ###
REM ### The calling application passes environment variables to this   ###
REM ### batch script in order to allow some flexibility with the       ###
REM ### certificate creation.                                          ###
REM ### In general, the default should be good for all your needs      ###
REM ###                                                                ###
REM ######################################################################

if NOT exist CertChainBuilder.exe goto missing_CertChainBuilder

IF "%PROVISIONING_CHAIN_FILE%"==""  SET PROVISIONING_CHAIN_FILE=cchain.raw

set PROVISIONING_KEY_FILE=newkey.pem
set PROVISIONING_CERT_FILE=newcert.pem

REM ### create web server leaf certificate for AMT ###
call certgen.bat
if errorlevel 1 goto certgen_error

REM ### create certificate ###
CertChainBuilder %PROVISIONING_CHAIN_FILE% %PROVISIONING_CERT_FILE% subCA\subcacert.pem
goto end

:missing_CertChainBuilder
echo %0 requires CertChainBuilder.exe 
pause
goto end

:certgen_error
echo problem in call to certgen.bat
pause
goto end

:end